import {
    Modal,
    Pressable,
    StyleSheet,
    TextInput,
    TouchableOpacity,
    View,
} from 'react-native';
import React, { useRef } from 'react';
import { featureDisplayStyle } from '../../Home/FeatureDIsplay/featureDisplay.style';
import SearchFilter1 from '../SearchFilter1/SearchFilter1';
import CommonStyles from '../../Utilities/CommonStyles/CommonStyles';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';
import BackIcon from '../../../assets/svgs/backButton.svg';
import SearchIcon from '../../../assets/svgs/searchIcon.svg';
import { homeStyle } from '../../Home/homeStyle';
import { useState } from 'react';
import { useEffect } from 'react';
import { getsearchProducts } from '../../../redux/slices/searchProducts/searchProducts';

import { BASE_API_URL_STG } from '@env';
import { useDispatch } from 'react-redux';
import useAuth from '../../../hooks/useAuth';
import Filters from '../Filters/Filters';
import SelectItemBottomSheet from '../../../src/components/SelectItemBottomSheet/SelectItemBottomSheet';
import useLangTranslation from '../../../hooks/useLangTranslation';
import { useCallback } from 'react';
import CustomSVG from '../../../src/components/CustomSVG/CustomSVG';

const FoundContent = (props) => {
    const { trans } = useLangTranslation();

    const sortByArray = [
        { name: trans("Price Low to High"), value: 'Price Low to High' },
        { name: trans("Price High to Low"), value: 'Price High to Low' },
        { name: trans("Avg. Ratting"), value: 'Avg. Ratting' },
    ];

    const { searchContent } = props?.route?.params || {};
    const { access_token } = useAuth();
    const dispatch = useDispatch();
    const [searchText, setSearchText] = useState(searchContent);
    const [filterModal, setFilterModal] = useState(false);
    const sortByRef = useRef(null);
    const [sortBy, setSortBy] = useState(sortByArray[0]);
    const SearchURL = `${BASE_API_URL_STG}/user/products?keyword=${searchText}&sort_by=${sortBy?.value}`;
    const [URL, setURL] = useState(SearchURL);
    const [filterUrl, setFilterUrl] = useState(URL);

    const [stars, setStars] = useState(0);
    const [minPrice, setMin_Price] = useState(0);
    const [maxPrice, setMax_Price] = useState(0);
    let postUrl = useRef("");

    useEffect(() => {
        (async () => {
            let res = await dispatch(getsearchProducts({ access_token, URL: SearchURL }));
            let priceRange = res?.payload?.records?.filterable?.price_range;
            setMin_Price(parseInt(priceRange[0]))
            setMax_Price(parseInt(priceRange[1]))
        })()
    }, []);

    function debounce(func, timeout = 1000) {
        let timer;
        return (...args) => {
            clearTimeout(timer);
            timer = setTimeout(() => {
                func.apply(this, args);
            }, timeout);
        };
    }
    const processChange = (text) => {
        const SearchURL = `${BASE_API_URL_STG}/user/products?keyword=${text}&sort_by=${sortBy.value}`;
        setURL(SearchURL);
        dispatch(getsearchProducts({ access_token, URL: SearchURL }));
    };
    const handleChangeText = useCallback(
        debounce((text) => processChange(text)),
        []
    );

    const handleSortBy = (item) => {
        setSortBy(item);
        const SearchURL = `${BASE_API_URL_STG}/user/products?keyword=${searchText}&sort_by=${item.value}`;
        dispatch(getsearchProducts({ access_token, URL: SearchURL }));
    };

    const [loadBtmSheet, setLoadBtmSheet] = useState(true);
    useEffect(() => {
        setLoadBtmSheet(true);
    }, []);
    return (
        <>
            <View>
                <View style={CommonStyles.container}>
                    <TouchableOpacity
                        style={CommonStyles.customHeaderIcon}
                        onPress={() => props.navigation.goBack()}
                    >
                        <CustomSVG svgIcon={BackIcon} isRtl={1} />
                    </TouchableOpacity>
                </View>
                <View style={homeStyle.searchContainer}>
                    <TextInput
                        placeholder={trans('Search')}
                        style={homeStyle.searchTextField}
                        value={searchText}
                        autoFocus={true}
                        onChangeText={(text) => {
                            setSearchText(text);
                            handleChangeText(text);
                        }}
                    />
                    <Pressable style={homeStyle.searchIcon}>
                        <CustomSVG svgIcon={SearchIcon} width={dpr(16)} height={dpr(16)} />
                    </Pressable>
                </View>
            </View>
            <View style={featureDisplayStyle.const}>
                <SearchFilter1
                    searchContent={searchText}
                    setFilterModal={setFilterModal}
                    sortByRef={sortByRef}
                    sortBy={sortBy}
                    sortByArray={sortByArray}
                />
            </View>
            <Modal 
                onRequestClose={() => setFilterModal(false)} 
                visible={filterModal} animationType='slide'
            >
                <Filters
                    {...props}
                    searchContent={searchText}
                    setFilterModal={setFilterModal}
                    URL={URL}
                    sortByArray={sortByArray}
                    setSortBy={setSortBy}
                    stars={stars}
                    setStars={setStars}
                    minPrice={minPrice}
                    setMin_Price={setMin_Price}
                    maxPrice={maxPrice} 
                    setMax_Price={setMax_Price}
                    postUrl={postUrl}
                    filterUrl={filterUrl}
                    setFilterUrl={setFilterUrl}
                />
            </Modal>
            {loadBtmSheet && (
                <SelectItemBottomSheet
                    snapPoint={[300]}
                    selectRef={sortByRef}
                    data={sortByArray}
                    name={'SortBy'}
                    onPress={handleSortBy}
                />
            )}
        </>
    );
};

export default FoundContent;

const styles = StyleSheet.create({});
